#!/bin/bash
# trap 'kill $( ps -A | grep "Terminal" | xargs | cut -d " " -f 1 )' EXIT
## Removed rather redundant archiving and multiple profiles in this version.
setup() {
echo 'Setup started successfully. Hello!'
echo "Please setup your storage location."
read -r -p "Location: "
SETUPLOCATION=$(echo $REPLY | xargs | sed 's|\/$||' | sed 's|\(.$\)|\1\/|' )
SETUPLOCATION=$(echo $SETUPLOCATION | xargs)
if [[ $SETUPLOCATION == "" ]]; then echo 'Empty location value!' "Make sure that there are no unusual characters in the location path entered."; echo Exiting.; exit; fi
echo "Creating files, please wait..."
if [[ -a "$SETUPLOCATION" ]]; then read -p "Location set at ${SETUPLOCATION}, continue? (Y/n): "; if [[ $REPLY == "" ]]; then REPLY="Y"; fi; if [[ $REPLY == [Yy] ]]; then true; else exit; fi
else read -p "Location for setup at $SETUPLOCATION not found. Would you like to create it? " ; if [[ $REPLY == [Yy] ]] ; then mkdir -p "$SETUPLOCATION" ; else exit; fi; fi
cd "$SETUPLOCATION" ## ' ## Comment was to fix buggy syntax highlighting, ignore.
if [[ $? != 0 ]]; then echo 'Something went wrong! Setting current directory repored failure! Exiting!'; exit; fi
## Check to see if grep finds data for the file. This shows that the current working directory was once a storage location. grep -s will suppress errors with reading files.
if [[ $(grep -s "$SETUPLOCATION" ./INFO/settings.txt) != "" ]]; then read -p 'Current setup location already exists! Do you want to continue? (Y/N): '; if [[ "$REPLY" == [Yy] ]]; then echo "Continuing. Things may be weird."; else echo 'Aborting!'; exit; fi; fi
mkdir INFO; mkdir STORAGE
if [[ -L "$HOME"./MBShifterRedirect ]]; then rm "$HOME"/.MBShifterRedirect; echo "Old reference to settings removed."; fi
ln -fns "$PWD"/INFO/settings.txt "$HOME"/.MBShifterRedirect ## TO, FROM
echo "Saving final location..."
echo 'SETUPLOCATION=''"'"$(echo "$SETUPLOCATION" | sed 's|\\\ |\ |g')"'"' >>./INFO/settings.txt ## Fun with quotes.
echo "Please specify MarbleBlast versions, as a short single-word acronym or abbreviation. For example, MarbleBlast Platinum is MBP"
echo "Enter nothing to finish."
REPLY="MB" ## doesn't actually go in, just to make it not empty.
echo -e "\n" >> ./INFO/VERSIONLIST.txt
echo -e "\nVersions: "
while [[ $REPLY != "" ]]; do read; echo $REPLY >> ./INFO/VERSIONLIST.txt ; done
cat ./INFO/VERSIONLIST.txt | sort | uniq | tr " " "_" | tr -s "\n" > ./INFO/VERSIONLIST.txt 
read -p "List all versions? (Y/N): " YESNO
if [[ $YESNO == [Yy] ]]; then echo -e "\nSet versions: \n$(cat ./INFO/VERSIONLIST.txt ) \n"; fi
echo "Making more folders..."
while read version; do if [[ $version != "" ]]; then mkdir ./STORAGE/$version; fi ; done <./INFO/VERSIONLIST.txt
## regenerate file listings
ls STORAGE/ > ./INFO/StoreList.txt
echo "List Updated. You can make new folders in the STORAGE folder, and it will automatically include them. But please avoid spaces and quotes and the such, for the script probably will hate it."
echo "Now to set te active version. Type in the version number of the version loaded into your library."
if [[ ! -d $HOME/Library/ ]]; then Library=".Library"; else Library="Library"; fi ## Newer OSX versions have hidden the User's Library folder. .dotfiles are hidden by the Finder.
MBLIB="$HOME/$Library/MarbleBlast" ## Safe for moving. (no trailing /, so will move the directory, not the files inside)
declare -a LIST ## copied from below :P
i=0
while read line ; do echo -e "$line - $i" ; LIST[i]=$line ; i=$(((i + 1))) ; done < ./INFO/StoreList.txt
read -p "Enter the number to select the active version: "
echo "Selected: ${LIST[$REPLY]}"
VERSION=${LIST[$REPLY]}; echo "$VERSION" >./INFO/LASTVERSION.txt
echo "$VERSION" >$MBLIB/ACTIVEVERSION.TXT
if [[ -e ./INFO/LASTVERSION.txt ]]; then echo "LASTVERSION information set."; fi
cat ./INFO/settings.txt | sed 's|RUNSETUP.*||' >./INFO/settings.txt ## Make sure you aren't stuck in setup forever.
read -p "Press Enter to exit."
exit
}
## End of setup.

if [[ ! -d $HOME/Library/ ]]; then Library=".Library"; else Library="Library"; fi ## Newer OSX versions have hidden the User's Library folder. .dotfiles are hidden by the Finder.
MBLIB="$HOME/$Library/MarbleBlast" ## Safe for moving. (no trailing /, so will move the directory, not the files inside)

## Actual version rotating script. 
source "$HOME"/.MBShifterRedirect ## It gets where the data is stored by using a defaultly-placed symbolic link.
cd "$SETUPLOCATION"
clear
if [[ "$SETUPLOCATION" == "" ]]; then setup; exit; fi
if [[ "$RUNSETUP" == "TRUE" ]]; then setup; exit; fi ## Add this to your settings file as RUNSETUP=TRUE if you want to rerun it. (Don't add the $ sign.)
echo 'Started successfully. Hello!'
echo "Set location is $PWD"
read < ./INFO/LASTVERSION.txt LATESTVERSION
echo "Latest version was logged as from "$LATESTVERSION"/"
if [[ $FAILED == TRUE ]]; then echo "Last retrieval reported failure. Not archiving."; ARCHIVE=FALSE; elif [[ ! -d "$MBLIB"/ ]]; then echo "No MarbleBlast packet loaded into the Library. Not Archiving."; ARCHIVE=FALSE; else ARCHIVE=TRUE; fi; 
read -p "Continue? [Y/N]: "
if [[ $REPLY == [Yy] ]]; then echo 'Continuing!' ; else echo 'Canceling!' ; exit; fi
## Update list, current method.
ls STORAGE/ > ./INFO/StoreList.txt
echo "----------------" ## Spacing line.
echo "List Updated."
## Current prompting for versions and no profiles.


### Archiving functions ###

checkretrievalfail() {
if [[ -d "$MBLIB"/ ]]; then echo "Move successful!" ; echo "$VERSION" > ./INFO/LASTVERSION.txt; cat ./INFO/settings.txt | sed 's|FAILED.*||' > ./INFO/settings.txt; echo 'FAILED=FALSE' >> ./INFO/settings.txt
else echo "Move failed, no active MarbleBlast packet! Are the path and file valid?" ; echo "${VERSION} - FAILED" > ./INFO/LASTVERSION.txt; cat ./INFO/settings.txt | sed 's|FAILED.*||' > ./INFO/settings.txt; echo 'FAILED=TRUE' >> ./INFO/settings.txt; fi ## mark failure for next run.
}

checkarchivefail() {
if [[ -d "$MBLIB"/ ]]; then echo "Library/MarbleBlast never emptied! That's not normal!" ; echo "Process failure, terminating!" ; exit
else if [[ $SHIFTEDINFO != "FALSE" ]]; then echo "Move from ~/Library/ to STORAGE/"$LASTVERSION"/ successful!"; fi; fi
}

recoverfile() {
if [[ $FAILED == TRUE ]] && [[ $(cat "$MBLIB/ACTIVEVERSION.txt") == "" ]]; then dolostandfound; fi
if [[ $FAILED == TRUE ]] && [[ $(cat "$MBLIB/ACTIVEVERSION.txt") != "" ]]; then ACTIVEVERSION=$(cat "$MBLIB/ACTIVEVERSION.txt"); if [[ "$ACTIVEVERSION" == "$LATESTVERSION" ]]; then echo "Loaded file identified itself as the active file. Continue? [Y/N]: "; if [[ $REPLY == [Yy] ]]; then echo "Archving as normal (but making backup just in case!)"; backuparchive; mv "$MBLIB" ./STORAGE/"$LASTVERSION"/; fi; fi; fi
}

dolostandfound() {
DT=$(echo "$(date)" | cut -d " " -f 2- | tr \: \- | tr \  \_)
echo "Found unmarked file!"
if [[ ! -d ./LOST_FOUND/ ]]; then mkdir ./LOST_FOUND/; fi ## Test for nonexistence of recovery directory.
mkdir ./LOST_FOUND/$DT; mv "$MBLIB" ./LOST_FOUND/$DT/ ## Move the unknown file out to storage.
if [[ -d ./LOST_FOUND/$DT/MarbleBlast ]] && [[ ! -d "$MBLIB"/ ]]; then echo "Recovery successful! Library is now empty!"; fi 
echo "Clearing failure status!"; cat ./INFO/settings.txt | sed 's|FAILED.*||' > ./INFO/settings.txt; echo 'FAILED=FALSE' >> ./INFO/settings.txt
}

depositfile() {
## Deposit an identification file in case things go a bit awry.
echo $LATESTVERSION >$MBLIB/ACTIVEVERSION.TXT
}

backuparchive() {
DT=$(echo "$(date)" | cut -d " " -f 2- | tr \: \- | tr \  \_)
if [[ ! -d ./BACKUP/ ]]; then mkdir ./BACKUP/; fi ## Test for nonexistence of backup directory.
mkdir ./BACKUP/$DT/
if [[ -d STORAGE/"$LASTVERSION"/MarbleBlast/ ]]; then mv STORAGE/"$LASTVERSION"/MarbleBlast ./BACKUP/$DT/; fi
if [[ -d ./BACKUP/$DT/MarbleBlast/ ]]; then rm -R STORAGE/"$LASTVERSION"/MarbleBlast; fi
## To be followed by the rotation in the next part of the script.
}

rotate1() {
if [[ -d "$MBLIB"/ ]]; then if [[ -d STORAGE/"$LASTVERSION"/MarbleBlast/ ]]; then if [[ -d STORAGE/"$LASTVERSION"/MarbleBlast_old/ ]]; then rm -Rv STORAGE/"$LASTVERSION"/MarbleBlast_old ; fi; mv STORAGE/"$LASTVERSION"/MarbleBlast STORAGE/"$LASTVERSION"/MarbleBlast_old ; fi ; mv "$MBLIB"/ STORAGE/"$LASTVERSION"/ ; else echo "Library/MarbleBlast folder reported nonexistent. You must reretrieve a file."; fi
}

archcomp1() {
KEYA=`$MD5_ -q "$MBLIB"/"$USERMOD"/client/*refs*.cs`
KEYB=`$MD5_ -q ./STORAGE/"$LASTVERSION"/MarbleBlast/"$USERMOD"/client/*refs*.cs`
if [[ $KEYA != $KEYB ]]; then MODIFIED="TRUE" ; else MODIFIED="FALSE" ; fi;
}

retriever() {
## Copies file into the Library.
## echo "Running basic retriever!"
echo "Moving from STORAGE/"$VERSION"/MarbleBlast/ to ~/Library/MarbleBlast/" ; echo "----- $(date): Start -----" >> ./INFO/SHIFTINGLOG.txt; cp -Rpv STORAGE/"$VERSION"/MarbleBlast "$MBLIB" >> ./INFO/SHIFTINGLOG.txt; echo "----- $(date): End -----" >> ./INFO/SHIFTINGLOG.txt; depositfile
}

doRetrieval() {
## echo "Doing retrieving!"
retriever ## Retrieval from storage function
checkretrievalfail ## Make sure the file went into the Library.
}

doArchiving() {
## echo "Doing archiving!"

if [[ $ARCHIVE != FALSE ]]; then 
read < ./INFO/LASTVERSION.txt LASTVERSION
STUFFYS=`find STORAGE/"$LASTVERSION"/MarbleBlast_old/ -type f -mtime -5 \! -name "*.DS_Store"` ## I removed endless archving, do I need this?
if [[ $STUFFYS == "" ]]; then OLD="TRUE"; else OLD="FALSE"; fi ## simplified script version to [ incomplete thought ]
## Adapted prefs comparison
MD5_=$(which md5 || which md5sum)

if [[ -d "$MBLIB"/platinum/ ]]; then USERMOD="platinum"; archcomp1
elif [[ -d "$MBLIB"/marble/ ]]; then USERMOD="marble"; archcomp1
elif [[ -d "$MBLIB"/platinumbeta/ ]]; then USERMOD="platinumbeta"; archcomp1
else echo 'No marble or platinum folder!? Skipping modification test, assuming modified.' ; MODIFIED="TRUE" ; fi

## Too many nested conditional statements. I think it was worse. I think this mostly archives and loads the requested file.

## Not sure why I couldn't be consistent here. I believe they deal with the same files.
if [[ $OLD == "TRUE" ]]; then if [[ $MODIFIED != "TRUE" ]]; then read -p "Prefs.cs file doesn't seem to be modified. Delete duplicate? (Or else the rotation will continue.) [Y/N]: "
if [[ $REPLY == [Nn] ]]; then echo "Updating storage with possibly redundant archive." ; rotate1
else echo "Deleting duplicate file." ; rm -R "$MBLIB"/ ; fi ## Because it was old and unmodified.
else rotate1 ; fi
elif [[ $OLD == "FALSE" ]]; then if [[ $MODIFIED != "TRUE" ]]; then read -p "Prefs.cs of active file doesn't seem to be modified. Continue anyway? (Or else the duplicate data will be deleted.) [Y/N]: "
if [[ $REPLY == [Yy] ]]; then echo "Updating storage with possibly redundant archive." ; mv -f "$MBLIB"/ STORAGE/"$LASTVERSION"/
else echo "Deleting duplicate file." ; rm -R "$MBLIB"/ ; SHIFTEDINFO=FALSE; fi ## To say that the file wasn't actually shifted into storage, because it was deleted instead

else mv -f "$MBLIB"/ STORAGE/"$LASTVERSION"/ ; fi
else echo 'Indeterminate file modification date, just rotating!' ; rotate1 ; fi

checkarchivefail

fi ## If $ARCHIVE doesn't equal FALSE. (end of that statement)

}

actionlist() {
echo "----------------" ## Spacing line.
declare -a LIST ## makes me feel better
i=1 ## 0 causes a possible logic error with bad responses, by defaulting to the first entry. I think typing gibberish in your response may cause it to error and give a value of 1 for the selection.
while read line ; do echo -e "$line - $i" ; LIST[i]=$line ; i=$(((i + 1))) ; done < ./INFO/StoreList.txt
read -p "Enter the number for the requested version (NONE for nothing): "
## More selections!
echo "----------------" ## Spacing line.
if [[ $(ls ./STORAGE/"${LIST[$REPLY]}") == "" ]]; then echo "No files stored for that version!"; NOVERSION=TRUE; fi ## MAKEVARIABLESONTHESPOT=TRUE;
if [[ $NOVERSION != TRUE ]]; then if [[ "${LIST[$REPLY]}" != "" ]]; then echo "Selected: ${LIST[$REPLY]}"; RETRIEVE=TRUE; elif [[ $(echo $REPLY | tr none NONE) == "NONE" ]]; then if [[ -d "$MBLIB"/ ]]; then echo "Not retrieving. Archiving only."; RETRIEVE=FALSE; else echo 'Nothing in the library! Nothing to do! Safely exiting!'; exit; fi; else echo 'Nonexistent version!'; actionlist; fi
VERSION=${LIST[$REPLY]}
else NOVERSION=FALSE; actionlist; fi # :)
}

### END OF FUNCTIONS ###

actionlist
if [[ $? != 0 ]]; then echo 'You broke the function! Stop feeding nonsense to the input! Canceling!'; exit ; fi

## Will run if it seems it can't or shouldn't archive anything.
if [[ $ARCHIVE == FALSE ]]; then ## Note no "fi" 
## Following will run if it failed to load and a game was run, or if something weird happened. There may be a file if ARCHIVE=FALSE was set by a previous failure.
if [[ -d "$MBLIB"/ ]]; then echo 'MarbleBlast packet already in Library! Trying to recover...'; recoverfile; echo "Exiting! Restart."; exit; fi; fi
if [[ -d "$MBLIB"/ ]]; then ARCHIVE=TRUE; doArchiving; fi
if [[ $RETRIEVE != FALSE ]]; then doRetrieval; fi



read -p "Script finished! (Enter to exit.)" ## AKA End-Of-File
exit
## Made by promarbler14
## Also, screw normal scripting conventions.
